/**
* Script: system.js
* Written by: Radnen
* Updated: 12/18/2010
**/

/**
* Global System Object:
*  - determines the look and feel of all RadGui
*    components and states. This ultimately
*    determines the look and feel of your game.
**/
System = ({
	textFont    : LoadFont("RadGui/text.rfn"),
	textColor   : Colors.white,
	windowFont  : LoadFont("RadGui/windowtext.rfn"),
	menuWindow  : Resources.windowstyles.basicwindow,
	highlight   : LoadWindowStyle("RadGui/highlight.rws"),
	selected    : LoadWindowStyle("RadGui/selected.rws"),
	basicWindow : LoadWindowStyle("RadGui/basicwindow.rws"),
	bar         : LoadWindowStyle("RadGui/bar.rws"),
	btnup       : LoadWindowStyle("RadGui/btnup.rws"),
	btndn       : LoadWindowStyle("RadGui/btndn.rws"),
	btnov       : LoadWindowStyle("RadGui/btnov.rws"),
	selectSnd   : LoadSound("RadGui/select.wav"),
	cancelSnd   : LoadSound("RadGui/cancel.wav"),
	clickSnd    : LoadSound("RadGui/click.wav"),
	cantSnd     : LoadSound("RadGui/cant.wav"),
	bleepSnd    : LoadSound("RadGui/speakblip.wav"),
	tipFadeTime : 100,
	
	/**
	* drawText(x, y, text [, color]);
	*  - wrapper for font.drawText(x, y, text);
	*  - color: if defined, it will mask the text for only this blit instance.
	**/
	drawText: function(x, y, text, color) {
		if (color) this.textFont.setColorMask(color);
		this.textFont.drawText(x, y, text);
		if (color) this.textFont.setColorMask(this.textColor);
	},
	
	/**
	* drawTextBox(x, y, w, h, text [, color]);
	*  - wrapper for font.drawTextBox(x, y, w, h, o, text);
	*  - color: if defined, it will mask the text for only this blit instance.
	**/
	drawTextBox: function(x, y, w, h, text, color) {
		if (color) this.textFont.setColorMask(color);
		this.textFont.drawTextBox(x, y, w, h, 0, text);
		if (color) this.textFont.setColorMask(this.textColor);
	},
});